/*
 * PHPHChangeListener.java
 *
 * We'll display the current PH reading from the sensor to the specified
 * textbox as they come in
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PHSensorPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.PHChangeListener;
import com.phidgets.event.PHChangeEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PHPHChangeListener implements PHChangeListener{
    
    private JFrame appFrame;
    private JTextField phTxt;
    private JTextField potTxt;
    
    /** Creates a new instance of PHPHChangeListener */
    public PHPHChangeListener(JFrame appFrame, JTextField phTxt, JTextField potTxt)
    {
        this.appFrame = appFrame;
        this.phTxt = phTxt;
        this.potTxt = potTxt;
    }

    public void phChanged(PHChangeEvent pHChangeEvent)
    {
        try
        {
            PHSensorPhidget source = (PHSensorPhidget)pHChangeEvent.getSource();
            phTxt.setText(Double.toString(pHChangeEvent.getValue()));
            potTxt.setText(Double.toString(source.getPotential()));
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
